﻿--[[
SimpleMD
Author: Michael Joseph Murray aka Lyte of Lothar(US)
$Revision: 213 $
$Date: 2010-09-25 20:45:08 +0000 (Sat, 25 Sep 2010) $
Project Version: r216
contact: codemaster2010 AT gmail DOT com

Copyright (c) 2007-2010 Michael J. Murray aka Lyte of Lothar(US)
All rights reserved unless otherwise explicitly stated.
]]

SimpleMD = LibStub("AceAddon-3.0"):NewAddon("SimpleMD", "AceConsole-3.0", "AceComm-3.0", "AceTimer-3.0", "AceEvent-3.0", "LibSink-2.0")
local LSM = LibStub("LibSharedMedia-3.0")
local L = LibStub("AceLocale-3.0"):GetLocale("SimpleMD")

--upvalue frequently used globals
local strformat = string.format
local select = select
local unpack = unpack

--save the player's name for later identification
local pname = UnitName("player")
--timer handles for player cooldown
local readyTimer, fiveTimer, tenTimer, fifteenTimer
--checks for the CLEU handler
local mdOnCD, isTransferring
--forward declaration of the Comm hashtable
local prefixToMsg

--this allows us to disable bars/broadcasts in pvp settings where braodcasting can spam "You aren't in a party."
local allowedZones = {["none"] = true, ["pvp"] = false, ["arena"] = false, ["raid"] = true, ["party"] = true}

--function to determine if broadcasts should be sent
--we only broadcast if we are in a group (raid/party) and if we are in a non-pvp zone
local function IsInGroup()
	if (UnitInRaid("player") or GetNumPartyMembers() > 0) and allowedZones[select(2, IsInInstance())] then
		return true
	else
		return false
	end
end

function SimpleMD:OnInitialize()
	local defaults = {
		profile = {
			tenCD = L["%s has 10 seconds left on MD cooldown!"],
			fiveCD = L["%s has 5 seconds left on MD cooldown!"],
			fifteenCD = L["%s has 15 seconds left on MD cooldown!"],
			noCD = L["%s has MD ready!"],
			readiness = L["%s used Readiness! MD ready!"],
			tott_tenCD = L["%s has 10 seconds left on Tricks cooldown!"],
			tott_fiveCD = L["%s has 5 seconds left on Tricks cooldown!"],
			tott_fifteenCD = L["%s has 15 seconds left on Tricks cooldown!"],
			tott_noCD = L["%s has Tricks ready!"],
			channel = "",
			showInChannel = false,
			showInChat = false,
			showFloating = false,
			showSelf = true,
			showRW = false,
			showParty = false,
			showRaid = false,
			showYell = false,
			showBars = true,
			showGain = true,
			showFade = true,
			ready = true,
			ten = true,
			five = false,
			fifteen = false,
			showReadiness = true,
			texture = "Blizzard",
			font = "Friz Quadrata TT",
			--the normal bar color
			barColor = {0, 0.4, 0.08},
			tott_barColor = {0, 0.4, 0.08},
			--the color when transfering threat
			transferColor = {1, 1, 0},
			tott_transferColor = {1, 1, 0},
			--the color when finished transfering and on CD
			cooldownColor = {0, 0, 1},
			tott_cooldownColor = {0, 0, 1},
			--the color of the background of the timer bar
			bgColor = {0, 1, 0.04},
			tott_bgColor = {0, 1, 0.04},
			--the color of the background of the transfer bar
			transferBG = {1, 1, 0.59},
			tott_transferBG = {1, 1, 0.59},
			--the text color for the timer bars
			barTextColor = {1, 1, 1},
			--the text color for alerts
			txtColor = {1, 1, 1},
			bg_alpha = 1.0,
			textSize = 11,
			barScale = 1.0,
			barWidth = 195.00,
			barHeight = 17.00,
			growUp = false,
			reverse = false,
			stay = false,
			position = {},
			sinkOpts = {},
		}
	}

	self.db = LibStub("AceDB-3.0"):New("SimplemdDB", defaults, "Default")
	self.db.RegisterCallback(self, "OnProfileReset", "Reset")
	self.db.RegisterCallback(self, "OnProfileCopied", "Refresh")
	self.db.RegisterCallback(self, "OnProfileChanged", "Refresh")
	self:SetSinkStorage(self.db.profile.sinkOpts)
	
	--setup the addonID
	local ver, rev = "3.0", "216"
	rev = tonumber(rev) or -1
	local addonID
	if rev == -1 then
		addonID = "SimpleMD-" .. ver .. " SOURCE"
	else
		addonID = "SimpleMD-" .. ver .. " r" .. rev
	end
	
	--self.frame is an invisible frame to run the OnUpdate
	self.anchor, self.frame = self:CreateAnchor(addonID)
	self.timerbars = {} --storage for timer bars
	self.recyclePile = {} --hold on to the frames to reuse them
	self.idents = {} --map of caster to bar ref
	self.activeTransfers = {}
	
	--mapping of the possible incoming comm message
	--to the human friendly broadcasts
	prefixToMsg = {
		["SMDFIVE"] = self.db.profile.fiveCD,
		["SMDTEN"] = self.db.profile.tenCD,
		["SMDFIFTEEN"] = self.db.profile.fifteenCD,
		["SMDREADY"] = self.db.profile.noCD,
		["SMDFIVE_R"] = self.db.profile.tott_fiveCD,
		["SMDTEN_R"] = self.db.profile.tott_tenCD,
		["SMDFIFTEEN_R"] = self.db.profile.tott_fifteenCD,
		["SMDREADY_R"] = self.db.profile.tott_noCD,
	}
	
	self:RegisterChatCommand("smd", "OpenConfig", true, true)
	self:RegisterChatCommand("simplemd", "OpenConfig")
end

function SimpleMD:OnEnable()
	self.md_tex = [[Interface\Icons\ability_hunter_misdirection]]
	self.tott_tex = [[Interface\Icons\ability_rogue_tricksofthetrade]]
	self:RegisterComm("SimpleMD", "OnCommReceive")
	
	--to clear bars after leaving a raid/party
	self:RegisterEvent("RAID_ROSTER_UPDATE", "GroupStatus") 
	self:RegisterEvent("PARTY_MEMBERS_CHANGED", "GroupStatus")
	
	self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED", "CombatLogEvent")
end

function SimpleMD:Reset()
	self.anchor:ClearAllPoints()
	self.frame:ClearAllPoints()
	self.anchor:SetPoint("CENTER", UIParent, "CENTER")
	self.frame:SetPoint("CENTER", UIParent, "CENTER")
end

function SimpleMD:Refresh()
	local db = self.db.profile
	self.anchor:ClearAllPoints()
	self.frame:ClearAllPoints()
	if db.position.x then
		self.anchor:SetPoint(db.position.point, UIParent, db.position.anchor, db.position.x, db.position.y)
		self.frame:SetPoint(db.position.point, UIParent, db.position.anchor, db.position.x, db.position.y)
	else
		self.anchor:SetPoint("CENTER", UIParent, "CENTER")
		self.frame:SetPoint("CENTER", UIParent, "CENTER")
	end
end

function SimpleMD:OpenConfig()
	LoadAddOn("SimpleMD_Options")
	LibStub("AceConfigDialog-3.0"):Open("SimpleMD")
end

function SimpleMD:OnCommReceive(prefix, message, distro, sender)
	if sender ~= pname then
		if prefixToMsg[message] then
			self:PrintMessage(strformat(prefixToMsg[message], sender), false)
		end
	end
end

--dispatcher function to send to the right comm channel
function SimpleMD:Dispatch(message)
	if allowedZones[select(2, IsInInstance())] then
		if UnitInRaid("player") then
			self:SendCommMessage("SimpleMD", message, "RAID", nil, "NORMAL")
		elseif GetNumPartyMembers() > 0 then
			self:SendCommMessage("SimpleMD", message, "PARTY", nil, "NORMAL")
		end
	end
end

function SimpleMD:PrintMessage(message, isPlayer)
	--if isPlayer is true the message regards the player and the message needs to
	--be sent to any selected channels, if it is false then the message is about another hunter
	--and should only be displayed locally to the player
	
	if isPlayer then
		--print to chat frame
		if self.db.profile.showInChat and self.db.profile.showSelf then
			self:Print(message)
		end
		--print to Party chat
		if self.db.profile.showParty and GetNumPartyMembers() > 0 and GetNumRaidMembers() == 0 then
			SendChatMessage(message, "PARTY")
		end
		--print to Raid Chat
		if self.db.profile.showRaid and UnitInRaid("player") then
			SendChatMessage(message, "RAID")
		end
		--print to Raid Warning
		if (IsRaidLeader() or IsRaidOfficer()) and self.db.profile.showRW then
			SendChatMessage(message, "RAID_WARNING")
		end
		-- print to custom channel
		if self.db.profile.showInChannel and self.db.profile.channel ~= "" then
			SendChatMessage(message, "CHANNEL", nil, GetChannelName(self.db.profile.channel))
		end
		--print to Scrolling Text
		if self.db.profile.showFloating and self.db.profile.showSelf then
			self:Pour(message, self.db.profile.txtColor[1], self.db.profile.txtColor[2], self.db.profile.txtColor[3])
		end
	else
		--print to Scrolling Text mod
		if self.db.profile.showFloating then
			self:Pour(message, self.db.profile.txtColor[1], self.db.profile.txtColor[2], self.db.profile.txtColor[3])
		end
		--print to chat frame
		if self.db.profile.showInChat then
			self:Print(message)
		end
	end
end

-- 34477 misdirect
-- 35079 misdirect transfer buff
-- 23989 readiness
-- 57934 tricks of the trade
-- 59628 tricks of the trade transfer buff
function SimpleMD:CombatLogEvent(event, timestamp, subevent, sID, sName, sFlags, dID, dName, dFlags, spellID, spellName)
	if spellID == 34477 or spellID == 57934 then
		if subevent == "SPELL_CAST_SUCCESS" then
			if IsInGroup() then
				if self.db.profile.showBars then
					self:CreateTimerBar(sName, dName, 30, self.db.profile.reverse, self.db.profile.stay, self.db.profile.growUp, spellID == 34477)
				end
				if self.db.profile.showGain then
					if spellID == 34477 then
						self:PrintMessage(strformat(L["%s cast Misdirection on %s"], sName, dName), sName == pname)
					else
						self:PrintMessage(strformat(L["%s cast Tricks on %s"], sName, dName), sName == pname)
					end
				end
				self.activeTransfers[sName] = self:ScheduleTimer("BuffRotCheck", 30, sName, spellID == 34477)
			end
		elseif subevent == "SPELL_AURA_REMOVED" then
			--only execute here if the hunter/rogue cancels MD/ToT
			--the other removals are handled by :BuffRotCheck() or in the transfer buff section below
			if (not isTransferring) and IsInGroup() then
				self:CancelTimer(self.activeTransfers[sName])
				self.activeTransfers[sName] = nil
				if self.db.profile.showBars and self.idents[sName] then
					local r, g, b = unpack(spellID == 34477 and self.db.profile.cooldownColor or self.db.profile.tott_cooldownColor)
					self.idents[sName].timer:SetStatusBarColor(r, g, b, 1)
					local curTime = GetTime()
					self.idents[sName].start = curTime
					self.idents[sName].stop = curTime + 30
				end
				if sName == pname then
					fifteenTimer = self:ScheduleTimer("CooldownBroadcast", 15, 15, spellID == 34477) -- 15 second warning
					tenTimer = self:ScheduleTimer("CooldownBroadcast", 20, 10, spellID == 34477) -- 10 second warning
					fiveTimer = self:ScheduleTimer("CooldownBroadcast", 25, 5, spellID == 34477) -- 5 second warning
					readyTimer = self:ScheduleTimer("CooldownBroadcast", 30, 0, spellID == 34477) -- cooldown finished
					mdOnCD = true
				end
			end
		end
	--this is the 4 second buff that actually allows threat transfer
	elseif spellID == 35079 or spellID == 59628 then
		if subevent == "SPELL_AURA_APPLIED" then
			if IsInGroup() then
				self:CancelTimer(self.activeTransfers[sName]) --cancel the rot check
				isTransferring = true
				self.activeTransfers[sName] = nil
				if self.db.profile.showBars and self.idents[sName] then
					local curTime = GetTime()
					--update the bar to the transfer color/time
					self.idents[sName].redirectStart = curTime
					self.idents[sName].start = curTime
					self.idents[sName].stop = curTime + 30
					self.idents[sName].timer:Hide()
					self.idents[sName].redirect:Show()
					self.idents[sName].redirecting = true
				end
				if sName == pname then
					fifteenTimer = self:ScheduleTimer("CooldownBroadcast", 15, 15, spellID == 35079) -- 15 second warning
					tenTimer = self:ScheduleTimer("CooldownBroadcast", 20, 10, spellID == 35079) -- 10 second warning
					fiveTimer = self:ScheduleTimer("CooldownBroadcast", 25, 5, spellID == 35079) -- 5 second warning
					readyTimer = self:ScheduleTimer("CooldownBroadcast", 30, 0, spellID == 35079) -- cooldown finished
					mdOnCD = true
				end
			end
		--removal of the 4 sec transfer buff
		elseif subevent == "SPELL_AURA_REMOVED" then
			if IsInGroup() then
				isTransferring = false
				if self.db.profile.showBars and self.idents[sName] then
					local r, g, b = unpack(spellID == 35079 and self.db.profile.cooldownColor or self.db.profile.tott_cooldownColor)
					self.idents[sName].redirecting = false
					self.idents[sName].timer:SetStatusBarColor(r, g, b, 1)
					self.idents[sName].timer:Show()
					self.idents[sName].redirect:Hide()
				end
				if self.db.profile.showFade then
					if spellID == 35079 then
						self:PrintMessage(strformat(L["Misdirection fades from %s"], dName), sName == pname)
					else
						self:PrintMessage(strformat(L["Tricks fades from %s"], dName), sName == pname)
					end
				end
			end
		end
	--readiness casts, should pickup all hunters in the group
	elseif spellID == 23989 then
		if IsInGroup() then
			if subevent == "SPELL_CAST_SUCCESS" then
				if sName == pname and mdOnCD then
					self:CancelCooldownTimers() --cancel all CD message events
					mdOnCD = nil
				end
				if self.db.profile.showReadiness then
					self:PrintMessage(strformat(self.db.profile.readiness, sName), sName == pname)
				end
				if self.db.profile.showSelf and self.db.profile.showBars then
					self:ReadinessCheck(sName)
				end
			end
		end
	end
end

--determine if the main MD buff has expired due to timeout
--if it fades due to threat transfer the timed call to this function is cancelled
--this works because the aura for transfer is applied before the main aura is removed
function SimpleMD:BuffRotCheck(name, isMD)
	self.activeTransfers[name] = nil
	if self.db.profile.showBars and self.idents[name] then
		local r, g, b = unpack(isMD and self.db.profile.cooldownColor or self.db.profile.tott_cooldownColor)
		self.idents[name].timer:SetStatusBarColor(r, g, b, 1)
		local curTime = GetTime()
		self.idents[name].start = curTime
		self.idents[name].stop = curTime + 30
	end
	if name == pname then
		fifteenTimer = self:ScheduleTimer("CooldownBroadcast", 15, 15, isMD) -- 15 second warning
		tenTimer = self:ScheduleTimer("CooldownBroadcast", 20, 10, isMD) -- 10 second warning
		fiveTimer = self:ScheduleTimer("CooldownBroadcast", 25, 5, isMD) -- 5 second warning
		readyTimer = self:ScheduleTimer("CooldownBroadcast", 30, 0, isMD) -- cooldown finished
		mdOnCD = true
	end
end

function SimpleMD:CancelCooldownTimers()
	self:CancelTimer(readyTimer, true)
	self:CancelTimer(fiveTimer, true)
	self:CancelTimer(tenTimer, true)
	self:CancelTimer(fifteenTimer, true)
	
	readyTimer, fiveTimer, tenTimer, fifteenTimer = nil, nil, nil, nil
end

--Function for broadcasting the cooldown messages
--Do nothing if player is dead or ghost since they can't MD anymore (thanks Cerqua)
function SimpleMD:CooldownBroadcast(timeleft, isMD)
	if not UnitIsDeadOrGhost("player") then
		if timeleft == 10 then
			if self.db.profile.ten then
				if isMD then
					self:PrintMessage(strformat(self.db.profile.tenCD, pname), true)
					self:Dispatch("SMDTEN")
				else
					self:PrintMessage(strformat(self.db.profile.tott_tenCD, pname), true)
					self:Dispatch("SMDTEN_R")
				end
			end
		elseif timeleft == 15 then
			if self.db.profile.fifteen then
				if isMD then
					self:PrintMessage(strformat(self.db.profile.fifteenCD, pname), true)
					self:Dispatch("SMDFIFTEEN")
				else
					self:PrintMessage(strformat(self.db.profile.tott_fifteenCD, pname), true)
					self:Dispatch("SMDFIFTEEN_R")
				end
			end
		elseif timeleft == 5 then
			if self.db.profile.five then
				if isMD then
					self:PrintMessage(strformat(self.db.profile.fiveCD, pname), true)
					self:Dispatch("SMDFIVE")
				else
					self:PrintMessage(strformat(self.db.profile.tott_fiveCD, pname), true)
					self:Dispatch("SMDFIVE_R")
				end
			end
		elseif timeleft == 0 then
			if self.db.profile.ready then
				if isMD then
					self:PrintMessage(strformat(self.db.profile.noCD, pname), true)
					self:Dispatch("SMDREADY")
				else
					self:PrintMessage(strformat(self.db.profile.tott_noCD, pname), true)
					self:Dispatch("SMDREADY_R")
				end
			end
			mdOnCD = nil
		end
	end
end

--see if the player is in a raid or party
--if they are not: clear the CD bars
function SimpleMD:GroupStatus()
	if GetNumPartyMembers() == 0 or (not UnitInRaid("player")) then
		self:ClearTimerBars()
	end
end

--Disable the bars and immediately cancel all running CD timers
function SimpleMD:DisableBars()
	if self.db.profile.showBars then
		self.db.profile.showBars = false
	else
		self.db.profile.showBars = true
	end
	
	self:ClearTimerBars()
end
